/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.core.Core;
import org.jetbrains.annotations.ApiStatus;

public final class AnimationUtils {
    private static final ThreadLocal<AnimationState> sAnimationState = ThreadLocal.withInitial(AnimationState::new);

    @ApiStatus.Internal
    public static void lockAnimationClock(long vsyncMillis) {
        AnimationState state = sAnimationState.get();
        state.animationClockLocked = true;
        state.currentVsyncTimeMillis = vsyncMillis;
    }

    @ApiStatus.Internal
    public static void unlockAnimationClock() {
        AnimationUtils.sAnimationState.get().animationClockLocked = false;
    }

    public static long currentAnimationTimeMillis() {
        AnimationState state = sAnimationState.get();
        if (state.animationClockLocked) {
            return Math.max(state.currentVsyncTimeMillis, state.lastReportedTimeMillis);
        }
        state.lastReportedTimeMillis = Core.timeMillis();
        return state.lastReportedTimeMillis;
    }

    private AnimationUtils() {
    }

    private static class AnimationState {
        boolean animationClockLocked;
        long currentVsyncTimeMillis;
        long lastReportedTimeMillis;

        private AnimationState() {
        }
    }
}

